<?php

namespace App\Http\Controllers;

use App\Http\Resources\LuggageResource;
use App\Models\Booking;
use App\Models\Luggage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LuggageController extends Controller
{
    public function store(Request $request)
    {
        $user = Auth::user();
        $validated = $request->validated();

        $booking = Booking::findOrFail($validated['booking_id']);

        if ($booking->user_id !== $user->id) {
            return $this->error([
                'message' => 'Unauthorized to add luggage to this booking.',
            ], 403);
        }

        $luggage = Luggage::create([
            'booking_id' => $booking->id,
            'user_id' => $user->id,
            'weight' => $validated['weight'],
            'type' => $validated['type'],
            // luggage_code auto-generated in model boot()
        ]);

        return $this->success([
            'message' => 'Luggage added successfully.',
            'data' => new LuggageResource($luggage),
        ], 201);
    }
}
