<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Booking extends Model
{
    protected $fillable = [
        'company_id', 'trip_id', 'passenger_id', 'seat_number',
        'luggage_weight', 'serial_code', 'payment_status', 'booking_status',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function trip()
    {
        return $this->belongsTo(Trip::class);
    }

    public function passenger()
    {
        return $this->belongsTo(User::class, 'passenger_id');
    }

    public function payment()
    {
        return $this->hasOne(Payment::class);
    }

    public function receipt()
    {
        return $this->hasOne(Receipt::class);
    }
}
