<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Company extends Model
{
    protected $fillable = [
        'company_name', 'company_email', 'company_phone', 'logo', 'address',
    ];

    public function states()
    {
        return $this->hasMany(State::class);
    }

    public function terminals()
    {
        return $this->hasMany(Terminal::class);
    }

    public function users()
    {
        return $this->hasMany(User::class);
    }

    public function trips()
    {
        return $this->hasMany(Trip::class);
    }

    public function bookings()
    {
        return $this->hasMany(Booking::class);
    }
}
