<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Luggage extends Model
{
    protected $fillable = [
        'booking_id',
        'user_id',
        'luggage_code',
        'weight',
        'type',
        'status',
    ];

    public function booking()
    {
        return $this->belongsTo(Booking::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    protected static function booted()
    {
        static::creating(function ($luggage) {
            // Generate a code like BOOKINGCODE-L{n}
            $booking = $luggage->booking;
            $count = Luggage::where('booking_id', $booking->id)->count() + 1;

            $luggage->luggage_code = "{$booking->booking_code}-L{$count}";
        });
    }
}
