<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Terminal extends Model
{
    protected $fillable = ['company_id', 'state_id', 'name', 'address'];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function state()
    {
        return $this->belongsTo(State::class);
    }

    public function staff()
    {
        return $this->hasMany(User::class)->where('role', 'staff');
    }

    public function originTrips()
    {
        return $this->hasMany(Trip::class, 'origin_terminal_id');
    }

    public function destinationTrips()
    {
        return $this->hasMany(Trip::class, 'destination_terminal_id');
    }
}
