<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Trip extends Model
{
    protected $fillable = [
        'company_id', 'origin_terminal_id', 'destination_terminal_id',
        'departure_time', 'vehicle_type', 'base_price', 'status',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function origin()
    {
        return $this->belongsTo(Terminal::class, 'origin_terminal_id');
    }

    public function destination()
    {
        return $this->belongsTo(Terminal::class, 'destination_terminal_id');
    }

    public function bookings()
    {
        return $this->hasMany(Booking::class);
    }
}
