<?php

namespace App\Traits;

trait HttpResponses
{
    protected function success(array $payload = [], int $httpCode = 200)
    {
        return response()->json([
            'success' => true,
            'message' => $payload['message'] ?? 'Request successful.',
            'code' => $payload['code'] ?? $httpCode,
            'data' => $payload['data'] ?? null,
        ], $httpCode);
    }

    protected function error(array $payload = [], int $httpCode = 400)
    {
        return response()->json([
            'success' => false,
            'message' => $payload['message'] ?? 'An error occurred.',
            'code' => $payload['code'] ?? $httpCode,
            'errors' => $payload['data'] ?? null,
        ], $httpCode);
    }
}
