<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('trips', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained()->cascadeOnDelete();
            $table->foreignId('origin_terminal_id')->constrained('terminals')->cascadeOnDelete();
            $table->foreignId('destination_terminal_id')->constrained('terminals')->cascadeOnDelete();
            $table->dateTime('departure_time');
            $table->string('vehicle_type'); // e.g. Sienna
            $table->decimal('base_price', 10, 2);
            $table->enum('status', ['scheduled', 'departed', 'cancelled'])->default('scheduled');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('trips');
    }
};
